<?php

namespace UtillzCore\Inc\Src\Form\Modules\Datetime;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Datetime extends Module {

    public function finish() {

        if( ! empty( $this->props->value ) ) {

            $datetime = new \DateTime();
            $datetime->setTimezone( new \DateTimeZone('GMT') );
            $datetime->setTimestamp( $this->props->value );
            $datetime->setTimezone( new \DateTimeZone( wp_timezone_string() ) );

            $this->props->value = [
                'year' => $datetime->format('Y'),
                'month' => $datetime->format('m'),
                'day' => $datetime->format('d'),
                'hour' => $datetime->format('H'),
                'minute' => $datetime->format('i')
            ];
        }

    }

    public function controller() {

        $months = [
            1 => esc_html__('Jan', 'utillz-core'),
            2 => esc_html__('Feb', 'utillz-core'),
            3 => esc_html__('Mar', 'utillz-core'),
            4 => esc_html__('Apr', 'utillz-core'),
            5 => esc_html__('May', 'utillz-core'),
            6 => esc_html__('Jun', 'utillz-core'),
            7 => esc_html__('Jul', 'utillz-core'),
            8 => esc_html__('Aug', 'utillz-core'),
            9 => esc_html__('Sep', 'utillz-core'),
            10 => esc_html__('Oct', 'utillz-core'),
            11 => esc_html__('Nov', 'utillz-core'),
            12 => esc_html__('Dec', 'utillz-core'),
        ];

        return array_merge( (array) $this->props, [
            'months' => $months,
            'strings' => (object) [
                'select_month' => esc_html__('Select month', 'utillz-core'),
                'month' => esc_html__('Month', 'utillz-core'),
                'day' => esc_html__('Day', 'utillz-core'),
                'year' => esc_html__('Year', 'utillz-core'),
                'hour' => esc_html__('Hour', 'utillz-core'),
                'minute' => esc_html__('Minute', 'utillz-core'),
            ],
        ]);

    }

}
